<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class CheckRole
{
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        /** @var User|null $user */
        $user = Auth::guard('sanctum')->user();

        if (!$user) {
            Log::warning('No authenticated user found in request.');
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthenticated.',
            ], 401);
        }

        $user->load('roles');

        Log::info('User Roles: ' . json_encode($user->roles->pluck('Name')));

        if (!$user->hasAnyRole($roles)) {
            Log::warning("User lacks required role(s): " . implode(', ', $roles));
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized action. Required role(s): ' . implode(', ', $roles),
            ], 403);
        }

        return $next($request);
    }
}
